#!/bin/sh

cd $(dirname $0)
ROOTDIR=$(pwd)

export PATH=$PATH:/bin:/sbin:/usr/bin/
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/lib:/usr/lib

echo
echo
echo
echo
echo "========================================"
echo "Update process starting at `date -u`"


PIDS=` ps --no-headers -o pid= -N -s $(ps -p $$ --no-headers -o sid )  `
# first stop ...
kill -19 $PIDS
# ... then kill
kill $PIDS
sleep 5
kill -9 $PIDS


echo
echo
echo
echo
init U

# umount mount points in length descending order (starting for longer to shorter to respect hierarchy)
echo "Umount fs..."
for mount_point in `cat /proc/mounts | grep old_root | awk '{ print length($2) " " $2; }' $file | sort -r -n | cut -d ' ' -f 2-` ; do
	umount -n $mount_point || ( sleep 3; umount -n $mount_point ) || umount -nl $mount_point
done

sync

# chroot and run the updater
# mount the image
mount -o loop /mnt/src/src/updateos.img /mnt/src/configos
# creates src mount point 
mkdir -p /mnt/src/configos/mnt/src
mount -o bind /mnt/src/ /mnt/src/configos/mnt/src
# copy dev files
cp -a /dev/* /mnt/src/configos/dev/
mkdir -p /mnt/src/configos/proc
mkdir -p /mnt/src/configos/sys
mount -t proc proc /mnt/src/configos/proc
mount -t sysfs sysfs /mnt/src/configos/sys

rm /mnt/src/configos/rotation
[ -e /rotation ] && cp /rotation /mnt/src/configos

cd /mnt/src/configos
# run the actual update
chroot . /mnt/src/src/update.sh

sync
