#!/bin/sh
#
# PLEASE DO NOT MODIFY THIS FILE IN ANY WAY
# Using this script after doing so may cause damage to the device
#

VERSION="1.42"

export PATH=$PATH:/bin/:/sbin/:/usr/bin/:/usr/sbin/:

cd $(dirname $0)
export USBDIR=$(pwd)
export UPDATEFS="$USBDIR/updatefs"
export USBMEMORYDEV="`df -h . | tail -n 1 | awk '{print $1}'`"

die()
{
	sleep 1

	echo $1; sync
	exec &>/dev/null
	sync

	umount "$UPDATEFS"
	/etc/init.d/dbus-1 restart

	psplash-write  "MSG ERROR STARTING USB UPDATER!!!
$1
Unplug the USB stick and reboot the device
"

	psplash-write "PROGRESS 100"

	if [ -n "$STATUS_LED" ]; then
		# Error led slow blinking. 1000/500 ms
		echo timer > "${STATUS_LED}/trigger"
		echo 1000 > "${STATUS_LED}/delay_on"
		echo 500 > "${STATUS_LED}/delay_off"
	fi

	echo 0 > $( echo /sys/class/leds/*:dl:usr0/brightness );

	while [ "1" ]; do
		dbus-send --system --print-reply --dest=com.exor.EPAD "/Buzzer" com.exor.EPAD.Buzzer.beep int32:440 int32:100 &>/dev/null; sleep 1;
		echo 0 > $( echo /sys/class/leds/*:fault:usr0/brightness ); sleep 1;
		echo 1 > $( echo /sys/class/leds/*:fault:usr0/brightness ); sleep 1;
	done

	# should never reach this point
	exit -1
}

exec &> lastupdate.log

killall -9 psplash

if [ -x /usr/bin/xsplash ]; then
	while [ ! -e /tmp/.X11-unix/X0 ]; do
		sleep 1;
	done
	sleep 2
	killall xsplash
	xsplash --no-taptap --no-progress-bar &>/dev/null &
else
	chvt 1
	sleep 1
	psplash --notouch &>/dev/null &
fi

sleep 1

[ -e "src/config" ] && . src/config

killall -9 psplash
psplash --notouch &>/dev/null &
sleep 1

HWCODE=$( cat /proc/cmdline | sed 's:.*hw_code=\([0-9]*\).*:\1:' )

case $HWCODE in
128)
        STATUS_LED="/sys/class/leds/na16:led:enable"
        ;;
132)
        STATUS_LED="/sys/class/leds/usr"
        ;;
esac

if [ -n "$STATUS_LED" ]; then
	# Running led fast blinking. 100/100 ms
	echo timer > "${STATUS_LED}/trigger"
	echo 100 > "${STATUS_LED}/delay_on"
	echo 100 > "${STATUS_LED}/delay_off"
fi

[ -e "src/backup" ] && CFG_ENABLE_BACKUP=1
[ "$CFG_ENABLE_BACKUP" == "1" -a "$( df -k . | sed -n 2p | awk '{ print $4 }' )" -lt $(( 1024 * 300 )) ] && die "Backup requires at least 300MB free space"

if [ -n "$CFG_ALLOWED_HWCODES" ]; then

	echo "Checking HW CODE. Compatible codes are: $HWCODES"

	echo "Hw code found: $HWCODE"

	for code in $HWCODES ; do
		[ "$code" = "$HWCODE" ] && codeCheckOK=1
	done
	[ -z "$codeCheckOK" ] && die "Uncompatible platform detected"
fi

OSTYPE=mainos
BSP_VERSION="$( cat /boot/version 2>/dev/null )"
if [ "${BSP_VERSION:8:1}" == "M" ]; then
	OSTYPE=mainos
else
	OSTYPE=configos
fi

echo "Detected $OSTYPE os"

if [ "$OSTYPE" == "mainos" -a "$CFG_ALLOW_MAINOS_UPDATE" != "1" ] ; then

	psplash-write "MSG Initializing USBUpdater
Reboot is required. Please wait...

"
	exec &>/dev/null
	sync

	sleep 6
	dbus-send --print-reply --system --dest=com.exor.EPAD "/" com.exor.EPAD.restartSystemWithImage int32:1
fi

echo "USBUpdater v$VERSION"

psplash-write "MSG Bootstrapping BSP updater...
"

# Create tmpfs mount point
mkdir -p "$UPDATEFS"
mount -t tmpfs tmpfs -o size=100M "$UPDATEFS"

tar xf src/updateos.img --warning=none -C "$UPDATEFS"

mkdir -p "$UPDATEFS/proc"
mount -t proc proc "$UPDATEFS/proc"

mkdir -p "$UPDATEFS/sys"
mount -t sysfs sysfs "$UPDATEFS/sys"

mkdir -p "$UPDATEFS/dev"
mount -t devtmpfs devtmpfs "$UPDATEFS/dev"
mount -t devpts devpts "$UPDATEFS/dev/pts"

mkdir -p "$UPDATEFS/run"
rm -rf "$UPDATEFS/var/run"
ln -sf /run "$UPDATEFS/var/run"

mkdir -p "$UPDATEFS/var/lib"

rm -rf "$UPDATEFS/tmp"
mkdir -p "$UPDATEFS/var/volatile/tmp"
ln -sf /var/volatile/tmp "$UPDATEFS/tmp"
mount -o bind /var/volatile/tmp "$UPDATEFS/var/volatile/tmp"

mkdir -p "$UPDATEFS/old_root"
mkdir -p "$UPDATEFS/mnt/usbmemory"

while [ ! -e /tmp/.X11-unix/X0 ] && !( pidof node); do
	sleep 1;
done

/etc/init.d/dbus-1 stop
/etc/init.d/jmuconfig stop

# BSP-2623 --make-shared causes pivot_root to fail, so revert to private mode 
mount --make-rprivate /mnt

rotation=0
[ -e /etc/rotation ] && rotation=$(cat /etc/rotation)

cd "$UPDATEFS"
pivot_root . old_root

DISPLAY=:0 \
OLD_ROOT=/old_root \
ROTATION=$rotation \
USBDIR=/mnt/usbmemory \
	chroot . /bin/bash -c "/etc/init.d/dbus-1 start; sleep 1; \
				mount --move /old_root/$USBDIR /mnt/usbmemory; \
				rm -rf /mnt/usbmemory/updatefs; \
				/mnt/usbmemory/src/usbupdater"

if [ "$?" -ne 0 ]; then
	# xsplash needs to be run from original/old root
	if [ -x /old_root/usr/bin/xsplash ]; then
		chroot old_root /bin/bash -c "DISPLAY=:0 xsplash &"
		sleep 1
		export TMPDIR=old_root/var/volatile/tmp
	else
		chvt 1
		killall -9 psplash
		psplash --notouch &
	fi
	die "Failed starting usbupdater"
fi
